dataset_class='safe'
gpu=0
adpt_td_weight=0.001
adpt_steps=1000
adpt_lr=0.05
use_wandb=0
export WANDB_INIT_TIMEOUT="300"
cvar_alpha=0.7
adpt_td_type='qf'


for env in OfflineBallRun-v0 OfflineCarRun-v0 OfflineAntRun-v0 OfflineDroneRun-v0 OfflineCarCircle-v0 OfflineBallCircle-v0 OfflineDroneCircle-v0 OfflineAntCircle-v0 
do
    for seed in 0 1 2
    do
    algo='Diffusion-QL'
    normalize_states=1
    adpt_batch_demo=128
    nohup python train_eval.py \
        --test_only 1 \
        --env $env\
        --seed $seed \
        --dataset $dataset_class\
        --gpu $gpu \
        --use_wandb $use_wandb \
        --algo $algo\
        --normalize_states $normalize_states\
        --adpt_td_weight $adpt_td_weight\
        --adpt_lr $adpt_lr\
        --adpt_steps $adpt_steps\
        --adpt_batch_demo $adpt_batch_demo\
        --adpt_td_type $adpt_td_type\
        --cvar_alpha $cvar_alpha\
    > logs/${env}_${dataset_type}_${seed}_test.txt &
    done

    for seed in 0 1 2
    do
    algo='PEDA'
    normalize_states=1
    adpt_batch_demo=128
    nohup python train_eval.py \
        --test_only 1 \
        --env $env\
        --seed $seed \
        --dataset $dataset_class\
        --gpu $gpu \
        --use_wandb $use_wandb \
        --algo $algo\
        --normalize_states $normalize_states\
        --adpt_td_weight $adpt_td_weight\
        --adpt_lr $adpt_lr\
        --adpt_steps $adpt_steps\
        --adpt_batch_demo $adpt_batch_demo\
        --adpt_td_type $adpt_td_type\
        --cvar_alpha $cvar_alpha\
    > logs/${env}_${dataset_type}_${seed}_test.txt &
    done

    for seed in 0 1 2
    do
    algo='Prompt-MODT'
    normalize_states=1
    w_step_size_final_eval=0.05
    adpt_batch_demo=32
    nohup python train_eval.py \
        --test_only 1 \
        --env $env\
        --w_step_size_final_eval $w_step_size_final_eval\
        --seed $seed \
        --dataset $dataset_class\
        --gpu $gpu \
        --use_wandb $use_wandb \
        --algo $algo\
        --normalize_states $normalize_states\
        --adpt_td_weight $adpt_td_weight\
        --adpt_lr $adpt_lr\
        --adpt_steps $adpt_steps\
        --adpt_batch_demo $adpt_batch_demo\
        --adpt_td_type $adpt_td_type\
        --cvar_alpha $cvar_alpha\
    > logs/${env}_${dataset_type}_${seed}_test.txt &
    gpu=$(($gpu+1))
    done

    for seed in 0 1 2 
    do
    algo='BC'
    normalize_states=1
    nohup python train_eval.py \
        --test_only 1 \
        --env $env\
        --seed $seed \
        --dataset $dataset_class\
        --gpu $gpu \
        --use_wandb $use_wandb \
        --algo $algo\
        --normalize_states $normalize_states\
        --adpt_td_weight $adpt_td_weight\
        --adpt_lr $adpt_lr\
        --adpt_steps $adpt_steps\
        --adpt_td_type $adpt_td_type\
        --cvar_alpha $cvar_alpha\
    > logs/${env}_${dataset_type}_${seed}_test.txt &
    gpu=$(($gpu+1))
    done

    gpu=$(($gpu+1))
done